'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Button_NeuerKalender_Click()
On Error GoTo Err_OutlookOrdnerlist_anzeigen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    'Variable vorbelegen
    FehlerFormularOeffnen = False
    OutlookOrdner_Art = "Termine"

    stDocName = "Outlook_Ordnerliste"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    If FehlerFormularOeffnen Then
        On Error Resume Next
        DoCmd.Close acForm, "Outlook_Ordnerliste", acSaveNo
        DoCmd.Close acForm, "Bitte_warten", acSaveNo
    End If
    

Exit_OutlookOrdnerlist_anzeigen_Click:
    Exit Sub

Err_OutlookOrdnerlist_anzeigen_Click:
    MsgBox err.Description
    Resume Exit_OutlookOrdnerlist_anzeigen_Click
    
    
    
''On Error GoTo Err_Button_NeuerKalender_Click
''
''    Dim stDocName As String
''    Dim stLinkCriteria As String
''
''    'Eigenen Formularnamen merken fr Aktualisierung
''    FormularName = "Einstellungen_2"
''    FormularBereich = "Steuersaetze"
''
''    'Eigentliches Formular ffnen
''    stDocName = "Steuersatz_neu"
''    DoCmd.OpenForm stDocName, , , stLinkCriteria
''
''
''Exit_Button_NeuerKalender_Click:
''    Exit Sub
''
''Err_Button_NeuerKalender_Click:
''    MsgBox Err.Description
''    Resume Exit_Button_NeuerKalender_Click
''
End Sub

Private Sub Button_KalenderLoeschen_Click()
    On Error GoTo ERROR_Button_KalenderLoeschen_Click

    Dim dbs As Database
    Dim rst As Recordset
    Dim rst2 As Recordset
    Dim strFilter As String
    Dim strFilter2 As String
    Dim strSource As String
    
    'Prfen, ob der aktuelle Datensatz im nderungsmodus ist, um einen Fehler beim Lschen zu vermeiden
    If Me.Dirty = True Then
        Me.Requery              ' "Speichern" und Aktualisieren
    End If
    
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen_2"
    FormularBereich = "Kalender"
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    Set rst = Me.RecordsetClone
    
    'wenn Datensatz vorhanden, dann lschen...
    If (rst.RecordCount = 0) Then
        Set dbs = Nothing
        MsgBox "Keine Kalendereintrge vorhanden.", vbInformation, "Hinweis"
    Else
    
        'Lschung verhindern, wenn Preise zu dem Kalender hinterlegt sind:
        strFilter = "SELECT * FROM Preise WHERE [lfd_Nr_Kalender] = " & AktKalender
        Set rst = dbs.OpenRecordset(strFilter)
        If rst.RecordCount > 0 Then
            rst.MoveLast        'Auffllen
            MsgBox "Diesem Kalender sind " & rst.RecordCount & " Preise zugeordnet." & vbNewLine _
                & "Bitte lschen Sie erst alle Preise des Kalenders, bevor Sie den Kalendereintrag lschen.", vbInformation + vbOKOnly, "Hinweis"
            rst.Close
            Set dbs = Nothing
            Exit Sub
        End If
        rst.Close
    
        strFilter = "SELECT * FROM Kalender WHERE [lfd_Nr] = " & AktKalender
        Set rst = dbs.OpenRecordset(strFilter)
        If MsgBox("Das Lschen des Kalenders lscht nur den Kalendereintrag. Termine, die von diesem Kalender " _
            & "bereits bernommen wurden, bleiben fr die Kalkulation, Abrechnung und Statistik erhalten." _
            & vbNewLine & vbNewLine & "Ausgewhlten Kalendereintrag [" & rst!Name & "] wirklich lschen?", vbYesNo + vbQuestion + vbDefaultButton2, "Kalender lschen...") = vbNo Then
            rst.Close
            Set dbs = Nothing
            Exit Sub
        End If
        rst.Delete
        rst.Requery
        rst.Close
        
        'Nummer des gelschten Kalenders aus den Termine lschen!:
        strFilter = "SELECT * FROM Termine WHERE [lfd_Nr_Kalender] = " & AktKalender
        Set rst = dbs.OpenRecordset(strFilter)
        If rst.RecordCount <> 0 Then
            rst.MoveLast        'Auffllen
            rst.MoveFirst
            Do While rst.EOF = False
                'Bevor der Kalendereintrag im Termin gelscht wird,
                'muss der Kalendereintrag auch in der Tabelle Termine_Kalender zu diesem Termin gelscht werden
                strFilter2 = "SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin] = " & rst!lfd_Nr
                Set rst2 = dbs.OpenRecordset(strFilter2)
                If rst2.RecordCount <> 0 Then
                    rst2.MoveLast
                    rst2.MoveFirst
                    Do While rst2.EOF = False
                        rst2.Edit
                        rst2!lfd_Nr_Kalender = -1
                        rst2.Update
                        rst2.MoveNext
                    Loop
                End If
                rst2.Close
                'und nun der eigentliche Termin:
                rst.Edit
                'Termine ohne Kalenderzuordnung haben die "-1", da die "0" in der Preistabelle fr
                '"kalenderbergreifender Preis" steht!
                rst!lfd_Nr_Kalender = -1
                rst.Update
                rst.MoveNext
            Loop
        End If
        rst.Close
        
        Set dbs = Nothing
        
        'Anzeige aktualisieren
        Me.Requery
        
    
    End If
    
EXIT_Button_KalenderLoeschen_Click:
    Exit Sub
    
ERROR_Button_KalenderLoeschen_Click:
    MsgBox err.Description
    Resume EXIT_Button_KalenderLoeschen_Click
    
End Sub

Private Sub Form_Current()
    AktKalender = Me.lfd_Nr.Value
End Sub

Private Sub Name_Feld_Change()
    If Me.Name_Feld.Text = "" Then
        MsgBox "Bitte geben Sie eine Kalenderbezeichnung ein.", vbCritical, "Fehler"
        Me.Name_Feld.SetFocus
    End If
End Sub

Private Sub Name_Feld_Enter()
    'wenn das Bezeichnungsfeld den Focus erhlt
    If Trim(Me.Name_Feld.Text) = "" Then
        MsgBox "Bitte geben Sie eine Kalenderbezeichnung ein.", vbCritical, "Fehler"
        Me.Name_Feld.Text = "Bezeichnung?"
        Me.Name_Feld.SetFocus
    End If
End Sub

Private Sub Name_Feld_Exit(Cancel As Integer)
    'wenn das Bezeichnungsfeld den Focus verliert
    If Trim(Me.Name_Feld.Text) = "" Then
        MsgBox "Der Kalenderordner hat keine Bezeichnung.", vbExclamation, "Achtung"
        Me.Name_Feld.Text = "Bezeichnung?"
        'nderung speichern
        Me.Recordset.Edit
        Me.Recordset.Update
    Else
        'nderung sofort speichern
        Me.Recordset.Edit
        Me.Recordset.Update
    End If
End Sub


